using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        string[] first = Console.ReadLine().Split();
        int N = int.Parse(first[0]);
        int Q = int.Parse(first[1]);

        int[] a = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
        List<int> results = new List<int>();

        for (int qi = 0; qi < Q; qi++)
        {
            string[] query = Console.ReadLine().Split();
            int type = int.Parse(query[0]);

            if (type == 2)
            {
                int index = int.Parse(query[1]) - 1;
                int value = int.Parse(query[2]);
                a[index] = value;
            }
            else
            {
                int k = int.Parse(query[1]);

                Dictionary<int, int> inHand = new Dictionary<int, int>();
                Dictionary<int, int> future = new Dictionary<int, int>();

                for (int i = k; i < N; i++)
                {
                    if (!future.ContainsKey(a[i]))
                        future[a[i]] = 0;
                    future[a[i]]++;
                }

                for (int i = 0; i < k; i++)
                {
                    if (!inHand.ContainsKey(a[i]))
                        inHand[a[i]] = 0;
                    inHand[a[i]]++;
                }

                for (int i = k; i < N; i++)
                {
                    int card = a[i];

                    if (!inHand.ContainsKey(card))
                        inHand[card] = 0;
                    inHand[card]++;

                    future[card]--;
                    if (future[card] == 0)
                        future.Remove(card);

                    int removeKey = -1;
                    int maxLoss = -1;

                    foreach (var p in inHand)
                    {
                        if (!future.ContainsKey(p.Key))
                        {
                            int loss = p.Key * p.Value;
                            if (loss > maxLoss)
                            {
                                maxLoss = loss;
                                removeKey = p.Key;
                            }
                        }
                    }

                    if (removeKey == -1)
                        removeKey = inHand.Keys.Min();

                    inHand.Remove(removeKey);
                }

                int sum = 0;
                foreach (var p in inHand)
                    sum += p.Key * p.Value;

                results.Add(sum);
            }
        }

        Console.WriteLine(string.Join("\n", results));
    }
}